<?php
/*###########################################
#  OnlineTicker           Version 1.0 beta  #
#  by Floern                    01.11.2009  #
#  http://floern.com/software/onlineticker  #
###########################################*/

error_reporting(E_ALL | E_STRICT);
@ini_set('html_errors', false);

header('Content-Type: text/plain');

# Info: "Onliners" ist die Bezeichnung für alle Benutzer, welche online sind.

// Einstellungen
define('TIC_CACHE_FILE', 'onlineTicker.cache.inc'); // Datei, in der die Onliner gespeichert werden

define('TIC_REPEATS', ini_get('max_execution_time')-1); // maximale Anzahl Überprüfungen pro Request
define('TIC_PAUSE', 1); // Wiederholung der Überprüfung nach X Sekunden
# WICHTIG: [TIC_REPEATS * TIC_PAUSE] darf die max_execution_time nicht übersteigen

define('TIC_OFFLINE_BUFFER', 3); // Puffer für Zeit-Überbrückung (Sekunden)

define('TIC_NL', "\n"); // Zeilenumbruch in der Cache-Datei

// UserAbort ignorieren, damit er verarbeitet werden kann
ignore_user_abort(true);

// ID des Users
$clientID = isset($_POST['id']) ? preg_replace('#[^[:alnum:]]+#', '', $_POST['id']) : die('Clientfehler #2');
// Angezeigter Onliner-Wert beim User
$clientVal = isset($_POST['val']) ? (int)$_POST['val'] : 1;

define('TIC_CLIENT_ID', $clientID);

$onliners = file(TIC_CACHE_FILE);
if($onliners===false) die('Serverfehler #1a');

foreach($onliners as $k => $onliner){
  $onlinerInfo = explode(' ', $onliner);
  if($onlinerInfo[0]===TIC_CLIENT_ID){ // sich selbst wieder als "online" markieren
	$onliners[$k] = $onlinerInfo[0];
	break;
  }
}
if(!in_array(TIC_CLIENT_ID, $onliners)){
  $onliners[] = TIC_CLIENT_ID; // ansonsten sich als Onliner neu hinzufügen
}

// aktualisierte Onliner-Datei speichern
$tmp = file_put_contents(TIC_CACHE_FILE, implode(TIC_NL, $onliners));
if($tmp===false) die('Serverfehler #2a');

unset($onliners);

// Puffer-Variablen, um kurzzeitige Schwankungen der Onliner-Anzahl zu ignorieren
$sumOnlinersPrev = $clientVal;
$sumOnlinersPrevPrev = $clientVal;

// Schleife starten
for($r=0; $r<=TIC_REPEATS; $r++){
  
  // Onliner-Datei öffnen
  $onliners = file(TIC_CACHE_FILE);
  if($onliners===false) die('Serverfehler #1b');
  $onliners = array_map('trim', $onliners);
  $onliners = array_unique($onliners);
	
  foreach($onliners as $k => $onliner){
	if($onliner===''){
	  unset($onliners[$k]); continue; // fehlerhafte Einträge löschen
	}
	$onlinerInfo = explode(' ', $onliner);
	if(isset($onlinerInfo[2],$onlinerInfo[1]) && TIC_OFFLINE_BUFFER+(int)$onlinerInfo[2] < time()){
	  unset($onliners[$k]); // "offline" User löschen
	}
  }

  $sumOnliners = count($onliners); // Onliner zählen
  
  # Onliner-Anzahl hat sich verändert, oder maximale Anzahl an Überprüfungen erreicht
  if(($sumOnliners !== $sumOnlinersPrevPrev && $r>0) || $r===TIC_REPEATS){
    // neue Onliner-Anzahl ausgeben
    echo $sumOnliners;
	
	foreach($onliners as $k => $onliner){
	  $onlinerInfo = explode(' ', $onliner);
	  if($onlinerInfo[0]===TIC_CLIENT_ID){ // sich selbst als "offline" markieren
	    $onlinerInfo[1] = 'off';
	    $onlinerInfo[2] = time();
		$onliners[$k] = implode(' ', $onlinerInfo);
		break;
	  }
	}
	$onlinersStr = implode(TIC_NL, $onliners);
	$tmp = file_put_contents(TIC_CACHE_FILE, $onlinersStr); // Onliner-Datei aktualisieren
    if($tmp===false) die('Serverfehler #2b');
	exit;
  }
  
  # Zweck-Datensendung, zur Überprüfung ob der Client noch anwesend ist
  echo ' ';
  flush();
  
  if(connection_status() !== CONNECTION_NORMAL){ // Der Benutzer ist offline gegangen
    $onliners = file(TIC_CACHE_FILE);
    $onliners = array_map('trim', $onliners);
    $onliners = array_unique($onliners);
	
	foreach($onliners as $k => $onliner){
	  $onlinerInfo = explode(' ', $onliner);
	  if($onlinerInfo[0]===TIC_CLIENT_ID){
		unset($onliners[$k]); // sich selbst löschen
		break;
	  }
	}
	$onlinersStr = implode(TIC_NL, $onliners);
	file_put_contents(TIC_CACHE_FILE, $onlinersStr); // Onliner-Datei aktualisieren
	exit;
  }
  
  // Puffer, damit kurzzeitige Schwankungen der Onliner-Anzahl ignoriert werden
  if($sumOnliners === $sumOnlinersPrevPrev)
    $sumOnlinersPrevPrev = $sumOnliners;
  else
    $sumOnlinersPrevPrev = $sumOnlinersPrev;
  $sumOnlinersPrev = $sumOnliners;
  
  unset($onliners);
  
  sleep(TIC_PAUSE); // Pause einlegen bis zum nächsten Durchgang
}

// Script wird clientseitig neu gestartet

// bis hierhin kommt das Script eh nicht...

?>