<?php
error_reporting(E_ALL | E_STRICT);
header('Content-Type: text/javascript; charset=UTF-8');

// Browser-Handling
$age = 3600*24*30; // 1 Monat
header('Pragma: public');
header('Cache-Control: maxage='.$age);
header('Last-Modified: '.gmdate('D, d M Y H:i:s', filemtime(basename($_SERVER['PHP_SELF']))).' GMT');
header('Expires: '.gmdate('D, d M Y H:i:s', time()+$age).' GMT');

// ID für den Clienten
$clientID = base_convert(strrev(uniqid('', false)), 16, 36);

?>
/*###########################################
#  OnlineTicker           Version 1.0 beta  #
#  by Floern                    01.11.2009  #
#  http://floern.com/software/onlineticker  #
###########################################*/

// ID des HTML-Elements, in welches die Ausgabe geschrieben werden soll
var tickerTarget = "onlineTicker_target";
// URL der Hintergrund-Datei
var tickerURL = "onlineTicker.bg.php";

// Benutzer-ID
var clientId = "<?php echo $clientID ?>";

// Ajax-Funktion
var htRequest = false;
function onlineTickerSignal(){
  htRequest = false;
  params = ""; // Parameter bzw. Informationen
  
  params += "id="+clientId; // Client-ID als Parameter
  
  clientVal = parseInt(document.getElementById(tickerTarget).firstChild.data);
  if(!clientVal)
    clientVal = 0;
  
  params += "&val="+clientVal; // "Wissensstand" des Clienten als Parameter
  
  // Ajax-Request vorbereiten
  if(window.XMLHttpRequest){ // FF & Co.
    htRequest = new XMLHttpRequest();
  }
  else if(window.ActiveXObject){ // IE
    try{
      htRequest = new ActiveXObject("Msxml2.XMLHTTP");
    }catch(e){
      try{
        htRequest = new ActiveXObject("Microsoft.XMLHTTP");
      }catch(e){
        document.getElementById(tickerTarget).innerHTML = "Clientfehler #1";
      }
    }
  }
  if(!htRequest){ // Fehler beim Client
    document.getElementById(tickerTarget).innerHTML = "Clientfehler #1";
    return false;
  }
  
  // Ajax-Request starten
  htRequest.onreadystatechange = function(){
    if(htRequest.readyState == 4){
      if(htRequest.status == 200){ // Serverantwort ausgeben
        response = htRequest.responseText.replace(/^ */, '');
        document.getElementById(tickerTarget).firstChild.data = response;
        if(response.length > 12) // ist 100%ig eine Fehlermeldung..
          return false; // ..daher Script abbrechen
      }
      else{ // Fehler beim Server
        document.getElementById(tickerTarget).firstChild.data = "Serverfehler #3";
      }
      // nächsten Request starten
      onlineTickerSignal();
    }
  };
  
  htRequest.open("POST", tickerURL, true);
  htRequest.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
  htRequest.setRequestHeader("Content-Length", params.length);
  htRequest.setRequestHeader("Connection", "close");
  htRequest.send(params);
}
