<?php
/*##############################################
#  SitemapCompiler                Version 1.0  #
#  by Floern                       01.11.2009  #
#  http://floern.com/software/sitemapcompiler  #
##############################################*/
error_reporting(E_ALL | E_STRICT);
date_default_timezone_set('Europe/Zurich');
header('Content-Type: text/html; charset=UTF-8');

$timeStart = microtime(true);
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
 <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
 <title>SitemapCompiler - <?php echo $_SERVER['HTTP_HOST'] ?></title>
 <meta name="generator" content="SitemapCompiler" />
 <style type="text/css">
	body{ margin: 0; padding: 10px 15px; font-family: Arial, sans-serif; font-size: 13px; color: #000; background: #fff; }
	h1{ font-family: Arial, sans-serif; font-size: 16px; color: #fff; font-weight: bold; margin: -10px -15px 12px -15px; padding: 6px 15px; background: #000; text-align: center; }
	#main{ text-align: center; }
	input[type="text"], textarea{ border: 1px solid #666; font-family: "Courier New", Courier, monospace; font-size: 12px; padding: 1px 3px; }
	.msgOk, .msgErr{ font-size: 12px; padding: 8px 0; border-style: solid; border-width: 1px 0; width: 770px; margin:4px auto; }
	.msgOk{ color: #111; border-color: #0a0; background: #9e9; }
	.msgErr{ color: #111; border-color: #f20; background: #faa; }
	a{ color: #03f; text-decoration: none; } a:hover{ color: #00c; }
	table{ font-size: 12px; border: 1px solid #000; border-collapse: collapse; width: 770px; margin: auto; }
	tr{ vertical-align: top; background: #fff; }
	tr:hover{ background: #f5f5f5; }
	td, th{ width: 150px; text-align: left; padding: 3px 5px; border: solid #000; border-width: 1px 0; }
	td+td, th+th{ width: 220px; }
	td+td+td, th+th+th{ width: auto; color: #888; font-size: 11px; }
	#footer{ color: #fff; background: #000; margin: 10px -15px -10px -15px; padding: 10px 0; text-align: center; }
	#footer a{ color: #9cf; } #footer a:hover{ color: #69f; }
 </style>
</head>
<body>

<h1>SitemapCompiler</h1>

<div id="main">

<?php

if(isset($_GET['sc_selectprofile']) || isset($_GET['autogenerate'], $_GET['sc_selectprofile'])){ // Profil laden
  # Profil auslesen
  $pfn = 'sc.profile.'.$_GET['sc_selectprofile'].'.txt';
  if(file_exists($pfn)){
    $profcont = file_get_contents($pfn);
    $profcont = trim($profcont, "; \r\n\t");
	$profents = explode(';', $profcont);
	$preconfigs = array();
	foreach($profents as $profentr){
	  list($cnfg, $value) = explode(':', $profentr, 2);
	  if($value=='1' || $value=='0')
	    $value = (bool)(int)$value;
	  elseif(preg_match('#^[0-9]{1,5}$#', $value))
	    $value = (int)$value;
	  else
	    $value = base64_decode($value);
	  $preconfigs[trim($cnfg)] = $value;
	}
  }
  else{
    echo '<div class="msgErr">Die Profil-Datei zum Profil "'.htmlspecialchars($_GET['sc_selectprofile']).'" konnte nicht gefunden werden.</div>';
  }
}

?>


<?php

if(isset($_POST['sc_send']) || isset($_GET['autogenerate'], $_GET['sc_selectprofile'], $preconfigs)){

$saveProfile = (isset($_POST['sc_saveProfile']) && $_POST['sc_saveProfile']==='y');
$saveProfileName = (!empty($_POST['sc_saveProfileName'])) ? preg_replace('#[^a-zA-Z0-9\.\-_]+#', '', $_POST['sc_saveProfileName']) : '';
if(empty($saveProfileName)) $saveProfileName = base_convert((string)time(), 10, 36);

$sitemapFile     = (!empty($_POST['sc_sitemapFile']) && preg_match('#^[[:alnum:]\.\-_]+$#', trim($_POST['sc_sitemapFile'])))
					? trim($_POST['sc_sitemapFile']) : 'sc.sitemap.xml';
$sitemapXsltFile = (!empty($_POST['sc_sitemapXsltFile']) && preg_match('#^[[:alnum:]\.\-_]+$#', trim($_POST['sc_sitemapXsltFile'])))
					? trim($_POST['sc_sitemapXsltFile']) : 'sc.sitemap.xsl';

$entryRobotsTxt = (isset($_POST['sc_entryRobotsTxt']) && $_POST['sc_entryRobotsTxt']==='y');

$scanLimit = (!empty($_POST['sc_scanLimit'])) ? (int)$_POST['sc_scanLimit'] : 1;

$scanDirectory = (!empty($_POST['sc_scanDirectory'])) ? preg_replace('#/+#', '/', '/'.$_POST['sc_scanDirectory'].'/') : '/';

$viewRobotsTxt  = (isset($_POST['sc_viewRobotsTxt'])  && $_POST['sc_viewRobotsTxt'] ==='y');
$viewRobotsMeta = (isset($_POST['sc_viewRobotsMeta']) && $_POST['sc_viewRobotsMeta']==='y');
$viewCanonical  = (isset($_POST['sc_viewCanonical'])  && $_POST['sc_viewCanonical'] ==='y');

$blockedLinks  = (!empty($_POST['sc_blockedLinks']))  ? $_POST['sc_blockedLinks']  : '';
$ignoredParams = (!empty($_POST['sc_ignoredParams'])) ? $_POST['sc_ignoredParams'] : '';
$sitePriority  = (!empty($_POST['sc_sitePriority']))  ? $_POST['sc_sitePriority']  : '';
$siteFrequency = (!empty($_POST['sc_siteFrequency'])) ? $_POST['sc_siteFrequency'] : '';


if($saveProfile){
  $profilestr = '';
  $profilestr .= 'sitemapFile:'.base64_encode($sitemapFile).';'.PHP_EOL;
  $profilestr .= 'sitemapXsltFile:'.base64_encode($sitemapXsltFile).';'.PHP_EOL;
  $profilestr .= 'entryRobotsTxt:'.intval($entryRobotsTxt).';'.PHP_EOL;
  $profilestr .= 'scanLimit:'.$scanLimit.';'.PHP_EOL;
  $profilestr .= 'scanDirectory:'.base64_encode($scanDirectory).';'.PHP_EOL;
  $profilestr .= 'viewRobotsTxt:'.intval($viewRobotsTxt).';'.PHP_EOL;
  $profilestr .= 'viewRobotsMeta:'.intval($viewRobotsMeta).';'.PHP_EOL;
  $profilestr .= 'viewCanonical:'.intval($viewCanonical).';'.PHP_EOL;
  $profilestr .= 'blockedLinks:'.base64_encode($blockedLinks).';'.PHP_EOL;
  $profilestr .= 'ignoredParams:'.base64_encode($ignoredParams).';'.PHP_EOL;
  $profilestr .= 'sitePriority:'.base64_encode($sitePriority).';'.PHP_EOL;
  $profilestr .= 'siteFrequency:'.base64_encode($siteFrequency).';'.PHP_EOL;
  if(file_put_contents('sc.profile.'.$saveProfileName.'.txt', $profilestr)!==false)
    echo '<div class="msgOk">Die Profil-Datei für das Profil "'.htmlspecialchars($saveProfileName).'" wurde gespeichert.</div>';
  else
    echo '<div class="msgErr">Die Profil-Datei für das Profil "'.htmlspecialchars($saveProfileName).'" konnte nicht gespeichert weden.</div>';
  unset($profilestr);
}


if(isset($_GET['autogenerate'], $_GET['sc_selectprofile'], $preconfigs)){
  # Variablen mit denen ausm Profil überschreiben
  foreach($preconfigs as $preconfig => $val){
    $$preconfig = $val;
  }
}
else{
  # Variablen fürs Formular
  $preconfigs['sitemapFile'] = $sitemapFile;
  $preconfigs['sitemapXsltFile'] = $sitemapXsltFile;
  $preconfigs['entryRobotsTxt'] = $entryRobotsTxt;
  $preconfigs['scanLimit'] = $scanLimit;
  $preconfigs['scanDirectory'] = $scanDirectory;
  $preconfigs['viewRobotsTxt'] = $viewRobotsTxt;
  $preconfigs['viewRobotsMeta'] = $viewRobotsMeta;
  $preconfigs['viewCanonical'] = $viewCanonical;
  $preconfigs['blockedLinks'] = $blockedLinks;
  $preconfigs['ignoredParams'] = $ignoredParams;
  $preconfigs['sitePriority'] = $sitePriority;
  $preconfigs['siteFrequency'] = $siteFrequency;
}

define('SC_HOSTNAME', $_SERVER['HTTP_HOST']);
define('SC_DIRECTORY', preg_replace('#/+#', '/', '/'.$scanDirectory.'/'));
define('SC_PROTOCOL', 'http://');

define('SC_SITEMAP_FILENAME', $sitemapFile);
define('SC_SITEMAP_XSLT', $sitemapXsltFile);

define('SC_MAX_SCAN_SITES', (int)$scanLimit);
define('SC_BYTE_RANGE', '0-24999');

define('SC_AGENT', 'SitemapCompiler/1.0');

define('SC_ROBOTS_TXT', SC_PROTOCOL.SC_HOSTNAME.'/robots.txt');

$dirups = substr_count($_SERVER['REQUEST_URI'], '/') -1;
$sitemapSaveDir = str_replace('//', '/', str_repeat('../', $dirups).SC_DIRECTORY);
$sitemapSaveDir = preg_replace('#^/#', '', $sitemapSaveDir);

define('SC_ROBOTS_TXT_LOCAL', str_replace('//', '/', str_repeat('../', $dirups).'robots.txt'));

$_SERVER['HTTP_ACCEPT'] = 'text/html,application/xhtml+xml;q=0.9,*/*;q=0.8';
$_SERVER['HTTP_ACCEPT_CHARSET'] = 'ISO-8859-1,utf-8;q=0.7,*;q=0.7';
$_SERVER['HTTP_ACCEPT_LANGUAGE'] = substr($_SERVER['HTTP_ACCEPT_LANGUAGE'], 0, 5);

$blockedFiles = array(); // benötigt bzgl. robots.txt und meta noindex // RegEx-formatiert

// Sitemap-Eintrag in robots.txt
if($entryRobotsTxt){
  $sitemapUrl = SC_PROTOCOL.SC_HOSTNAME.SC_DIRECTORY.SC_SITEMAP_FILENAME;
  if(!file_exists(SC_ROBOTS_TXT_LOCAL)){ // robots.txt neu erstellen
    file_put_contents(SC_ROBOTS_TXT_LOCAL, PHP_EOL.'Sitemap: '.$sitemapUrl);
  }
  else{
    $rbtxt = file_get_contents(SC_ROBOTS_TXT_LOCAL); // robots.txt kontrollieren
	if(!preg_match('#Sitemap: '.preg_quote($sitemapUrl, '#').'#', $rbtxt)){
      // robots.txt aktualisieren
	  file_put_contents(SC_ROBOTS_TXT_LOCAL, PHP_EOL.PHP_EOL.'Sitemap: '.$sitemapUrl, FILE_APPEND);
	}
  }
  unset($sitemapUrl, $rbtxt);
}

// robotx.txt prüfen
if($viewRobotsTxt){
  $htreq = curl_init();
  curl_setopt($htreq, CURLOPT_URL, SC_ROBOTS_TXT);
  curl_setopt($htreq, CURLOPT_CONNECTTIMEOUT, 5);
  curl_setopt($htreq, CURLOPT_USERAGENT, SC_AGENT);
  $header = array('Accept: '.$_SERVER['HTTP_ACCEPT'],
				  'Accept-Charset: '.$_SERVER['HTTP_ACCEPT_CHARSET'],
                  'Accept-Language: '.$_SERVER['HTTP_ACCEPT_LANGUAGE']);
  curl_setopt($htreq, CURLOPT_HTTPHEADER, $header);
  curl_setopt($htreq, CURLOPT_ENCODING, 'gzip,deflate');
  curl_setopt($htreq, CURLOPT_RETURNTRANSFER, true);
  $htres = curl_exec($htreq);
  $htresInfo = curl_getinfo($htreq);
  curl_close($htreq);
  if($htresInfo['http_code']==200){
    $rows = explode("\n", $htres);
	$rows = array_map('trim', $rows);
	$rowSum = count($rows);
	$blockedFilesRbt = array();
	for($r=0; $r<$rowSum; $r++){
	  if(preg_match('#User-Agent: \*#i', $rows[$r])){
	    while(isset($rows[++$r]) && preg_match('#Disallow: /#i', $rows[$r])){
		  $nbf = trim(preg_replace('#Disallow: /(.*)#i', '/$1', $rows[$r]));
		  if(substr($nbf, -1)==='*') $nbf = substr($nbf, 0, -1); // Wildcard löschen
		  $blockedFilesRbt[] = $nbf;
		}
	  }
	}
	foreach($blockedFilesRbt as &$blockedFileRbt){
	  $blockedFileRbt = '#^'.preg_quote(SC_PROTOCOL.SC_HOSTNAME.$blockedFileRbt, '#').'.*$#';
	}
	$blockedFiles = array_merge($blockedFiles, $blockedFilesRbt);
  }
  unset($htres, $htresInfo, $htreq, $blockedFileRbt);
}

// gesperrte Seitenanbschnitte
$blockedLinks = explode("\n", $blockedLinks);
$blockedLinks = array_map('trim', $blockedLinks);
while(in_array('', $blockedLinks))
  unset($blockedLinks[array_search('', $blockedLinks)]);
foreach($blockedLinks as &$blockedLink){
  $blockedLink = '#^'.str_replace('\*', '.*', preg_quote(SC_PROTOCOL.SC_HOSTNAME.$blockedLink, '#')).'$#';
}
unset($blockedLink);
$blockedFiles = array_merge($blockedFiles, $blockedLinks);
$blockedFiles = array_unique($blockedFiles);

// zu ignorierende Parameter vorbereiten
$ignoredParams = explode("\n", $ignoredParams);
$ignoredParams = array_map('trim', $ignoredParams);
while(in_array('', $ignoredParams))
  unset($ignoredParams[array_search('', $ignoredParams)]);

// spezifische Prioritäten vorbereiten
$sitePriorities = array(); // site => prio
$sitePriority = explode("\n", $sitePriority);
$sitePriority = array_map('trim', $sitePriority);
foreach($sitePriority as $prio){
  if(!preg_match('#^[0-9\.]+[ ]+/.*$#', $prio))
    continue; // ungültiger Eintrag
  list($priority, $psite) = explode(' ', $prio, 2);
  $psite = trim($psite);
  $priority = substr(trim($priority), 0, 3);
  if(preg_match('#^[01]$#', $priority))
    $priority .= '.0';
  if(!preg_match('#^[01]\.[0-9]$#', $priority))
    continue; // ungültige Priorität
  $sitePriorities[$psite] = $priority;
}

// spezifische Frequenzen vorbereiten
$siteFrequencies = array(); // site => freq
$possibleFreqs = array('always','hourly','daily','weekly','monthly','yearly','never');
$siteFrequency = explode("\n", $siteFrequency);
$siteFrequency = array_map('trim', $siteFrequency);
foreach($siteFrequency as $freq){
  if(!preg_match('#^[a-zA-Z]+[ ]+/.*$#', $freq))
    continue; // ungültiger Eintrag
  list($frequency, $fsite) = explode(' ', $freq, 2);
  $fsite = trim($fsite);
  $frequency = strtolower(trim($frequency));
  if(!in_array($frequency, $possibleFreqs, true))
    continue; // ungültige Frequenz
  $siteFrequencies[$fsite] = $frequency;
}



// Parameter für Regex preparieren
foreach($ignoredParams as &$ignprm){
  $ignprm = '#(\?|&)'.preg_quote($ignprm).'=[^&]*(&|$)#';
}
unset($ignprm);

$sites4sitemap = array(); // $url => $lastMod

$errorsLog = array();

$url = SC_PROTOCOL.SC_HOSTNAME.SC_DIRECTORY;

// nur Location folgen und Cookies setzen
list(, $url) = sc_scanURL($url, '', 2, true);

// anfangen zu scannen
sc_getNewSites($url);


$xmlSitemapContent = '<?xml version="1.0" encoding="UTF-8"?>'.PHP_EOL;
$xmlSitemapContent.= '<?xml-stylesheet type="text/xsl" href="'.SC_SITEMAP_XSLT.'"?>'.PHP_EOL;

$xmlSitemapContent.= '<!--
SitemapCompiler                Version 1.0
by Floern                       01.11.2009
http://floern.com/software/sitemapcompiler
-->'.PHP_EOL;

$xmlSitemapContent.= '<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9"'.PHP_EOL;
$xmlSitemapContent.= '	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"'.PHP_EOL;
$xmlSitemapContent.= '	xsi:schemaLocation="http://www.google.com/schemas/sitemap/0.84 http://www.sitemaps.org/schemas/sitemap/0.9/sitemap.xsd">'.PHP_EOL;

file_put_contents($sitemapSaveDir.SC_SITEMAP_FILENAME, $xmlSitemapContent);

foreach($sites4sitemap as $site => $lastMod){
  // gesperrte Seite
  foreach($blockedFiles as $blockedFile)
	if(preg_match($blockedFile, $site))
	  continue 2;
  $urlLocation = $site;
  $urlLastmod = date('Y-m-d', $lastMod);
  $urlPriority = '0.5';
  $urlFrequency = 'weekly';
  $urlParts = parse_url($site);
  foreach($sitePriorities as $psite => $prio){
	$usesWildcard = 0;
	$psite = preg_quote(trim($psite), '#');
	$pregex = str_replace('\*', '[^/]+', $psite, $usesWildcard);
	if(preg_match('#^'.$pregex.'$#s', $urlParts['path'])){
	  $urlPriority = $prio;
	  if($usesWildcard==0){
		break;
	  }
	}
  }
  foreach($siteFrequencies as $fsite => $freq){
	$usesWildcard = 0;
	$fsite = preg_quote(trim($fsite), '#');
	$fregex = str_replace('\*', '[^/]+', $fsite, $usesWildcard);
	if(preg_match('#^'.$fregex.'$#s', $urlParts['path'])){
	  $urlFrequency = $freq;
	  if($usesWildcard==0){
	    break;
	  }
	}
  }
  $trans = array('ä'=>'%C3%A4', 'ö'=>'%C3%B6', 'ü'=>'%C3%BC');
  $urlLocation = strtr($urlLocation, $trans);
  $xmlSitemapContent = '';
  $xmlSitemapContent.= ' <url>'.PHP_EOL;
  $xmlSitemapContent.= '  <loc>'.htmlspecialchars($urlLocation).'</loc>'.PHP_EOL;
  $xmlSitemapContent.= '  <lastmod>'.$urlLastmod.'</lastmod>'.PHP_EOL;
  $xmlSitemapContent.= '  <changefreq>'.$urlFrequency.'</changefreq>'.PHP_EOL;
  $xmlSitemapContent.= '  <priority>'.$urlPriority.'</priority>'.PHP_EOL;
  $xmlSitemapContent.= ' </url>'.PHP_EOL;
  file_put_contents($sitemapSaveDir.SC_SITEMAP_FILENAME, $xmlSitemapContent, FILE_APPEND);
}

$xmlSitemapContent = '</urlset>';
file_put_contents($sitemapSaveDir.SC_SITEMAP_FILENAME, $xmlSitemapContent, FILE_APPEND);

echo '<div class="msgOk">Die Sitemap <a href="'.$sitemapSaveDir.SC_SITEMAP_FILENAME.'" onclick="window.open(this.href);return false">'.SC_SITEMAP_FILENAME.'</a> wurde gespeichert.</div>';

# XSLT-Datei
$xsltContent = '<?xml version="1.0" encoding="UTF-8"?>
<!--############################################
#  SitemapCompiler                Version 1.0  #
#  by Floern                       01.11.2009  #
#  http://floern.com/software/sitemapcompiler  #
#  XSLT by Floern                              #
#############################################-->
<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:sitemap="http://www.sitemaps.org/schemas/sitemap/0.9">
 <xsl:output method="html" encoding="utf-8" doctype-public="-//W3C//DTD XHTML 1.1//EN" doctype-system="http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd"/>
 <xsl:template match="/">
  <html xmlns="http://www.w3.org/1999/xhtml">
   <head>
	<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
	<title>XML-Sitemap von '.SC_HOSTNAME.'</title>
	<meta name="generator" content="SitemapCompiler" />
	<style type="text/css">
	/*<![CDATA[*/
	body{ margin: 0; padding: 10px 15px; font-family: Calibri, Arial, sans-serif; font-size: 13px; color: #000; background: #fff; }
	h1{ font-family: Calibri, Arial, sans-serif; font-size: 16px; color: #fff; font-weight: bold; margin: -10px -15px 10px -15px; padding: 5px 15px; background: #000; }
	table{ font-size: 12px; border: 1px solid #000; border-collapse: collapse; width: 100%; }
	tr{ vertical-align: top; background: #fff; }
	tr:hover{ background: #f5f5f5; }
	tr:hover th{ background: #fff; }
	td, th{ width: 50%; text-align: left; padding: 2px 4px; border: solid #000; border-width: 1px 0; }
	td+td, th+th{ width: auto; text-align: center; }
	td+td+td, th+th+th{ color: #777; }
	a{ text-decoration: none; color: #009; }
	a:hover{ color: #12f; }
	#footer{ color: #fff; background: #000; margin: 10px -15px -10px -15px; padding: 10px 0; text-align: center; }
	#footer a{ color: #ccf; } #footer a:hover{ color: #aaf; }
	/*]]>*/
	</style>
   </head>
   <body>
	<h1>XML-Sitemap von '.SC_HOSTNAME.'</h1>
	<div>
	 XML-Sitemap generiert mit <b><a href="http://floern.com/software/sitemapcompiler">SitemapCompiler</a></b><br />
	 <xsl:variable name="sumRow"><xsl:value-of select="count(sitemap:urlset/sitemap:url)"/></xsl:variable>
	 Anzahl Seiten: <b><xsl:value-of select="$sumRow"/></b><br />
	 Dateigrösse: ca. <b><xsl:value-of select="substring(round($sumRow*1.74+3.4)*0.1, 1, 4)"/> KB</b><br />
	 <br />
	</div>
	<table>
	 <tr>
	  <th>Seite</th>
	  <th>Letzte Änderung</th>
	  <th>Aktualisierung</th>
	  <th>Priorität</th>
	 </tr>
	 <xsl:for-each select="sitemap:urlset/sitemap:url">
	  <xsl:sort select="sitemap:priority" order="descending"/>
	  <tr style="vertical-align:top;">
	   <xsl:variable name="siteURL"><xsl:value-of select="sitemap:loc"/></xsl:variable>
	   <td><a href="{$siteURL}"><xsl:value-of select="$siteURL"/></a></td>
	   <xsl:variable name="siteLMD"><xsl:value-of select="substring(sitemap:lastmod, 6, 2)"/></xsl:variable>
	   <td>
		<xsl:if test="sitemap:lastmod!=\'\'">
		 <xsl:choose>
		  <xsl:when test="substring(sitemap:lastmod, 9, 1)=\'0\'"><xsl:value-of select="substring(sitemap:lastmod, 10, 2)"/></xsl:when>
		  <xsl:otherwise><xsl:value-of select="substring(sitemap:lastmod, 9, 2)"/></xsl:otherwise>
		 </xsl:choose>.
		 <xsl:choose>
		  <xsl:when test="$siteLMD=\'01\'">Jan.</xsl:when>
		  <xsl:when test="$siteLMD=\'02\'">Feb.</xsl:when>
		  <xsl:when test="$siteLMD=\'03\'">März</xsl:when>
		  <xsl:when test="$siteLMD=\'04\'">Apr.</xsl:when>
		  <xsl:when test="$siteLMD=\'05\'">Mai</xsl:when>
		  <xsl:when test="$siteLMD=\'06\'">Juni</xsl:when>
		  <xsl:when test="$siteLMD=\'07\'">Juli</xsl:when>
		  <xsl:when test="$siteLMD=\'08\'">Aug.</xsl:when>
		  <xsl:when test="$siteLMD=\'09\'">Sep.</xsl:when>
		  <xsl:when test="$siteLMD=\'10\'">Okt.</xsl:when>
		  <xsl:when test="$siteLMD=\'11\'">Nov.</xsl:when>
		  <xsl:when test="$siteLMD=\'12\'">Dez.</xsl:when>
		  <xsl:otherwise><xsl:value-of select="$siteLMD"/>.</xsl:otherwise>
		 </xsl:choose>
		 <xsl:value-of select="substring(sitemap:lastmod, 1, 4)"/>
		</xsl:if>
	   </td>
	   <td>
		<xsl:choose>
		 <xsl:when test="sitemap:changefreq=\'always\'">immer</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'hourly\'">stündlich</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'daily\'">täglich</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'weekly\'">wöchentlich</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'monthly\'">monatlich</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'yearly\'">jährlich</xsl:when>
		 <xsl:when test="sitemap:changefreq=\'never\'">nie</xsl:when>
		 <xsl:otherwise><xsl:value-of select="sitemap:changefreq"/></xsl:otherwise>
		</xsl:choose>
	   </td>
	   <td>
		<xsl:choose>
		 <xsl:when test="sitemap:priority>=0.8"><b><xsl:value-of select="sitemap:priority*100"/>%</b></xsl:when>
		 <xsl:otherwise><xsl:value-of select="sitemap:priority*100"/>%</xsl:otherwise>
		</xsl:choose>
	   </td>
	  </tr>
	 </xsl:for-each>
	</table>
	<div id="footer">
	 <a href="http://floern.com/software/sitemapcompiler">SitemapCompiler 1.0</a> – 
	 <a href="http://www.sitemaps.org/">About Sitemaps</a>
	</div>
	<script language="JavaScript" implements-prefix="user">
	 //<![CDATA[
	 links = document.getElementsByTagName("a");
	 len = links.length;
	 for(i=0; i<len; i++){
	  url = links[i].firstChild.data;
	  url = url.replace("%C3%A4","ä");
	  url = url.replace("%C3%B6","ö");
	  url = url.replace("%C3%BC","ü");
	  links[i].firstChild.data = url;
	 }
	 //]]>
	</script>
   </body>
  </html>
 </xsl:template>
</xsl:stylesheet>';

file_put_contents($sitemapSaveDir.SC_SITEMAP_XSLT, $xsltContent);


$errorMsgs = array();

foreach($errorsLog as $error){
  list($errurl, $errno) = $error;
  if($errno===1){
    if(!isset($errorMsgs['Die URL ist ungültig oder benutzt ein nicht unterstütztes Protokoll'])) $errorMsgs['Die URL ist ungültig oder benutzt ein nicht unterstütztes Protokoll'] = array();
    $errorMsgs['Die URL ist ungültig oder benutzt ein nicht unterstütztes Protokoll'][] = $errurl;
  }
  elseif($errno===2){
    if(!isset($errorMsgs['Ressource ausserhalb der Site'])) $errorMsgs['Ressource ausserhalb der Site'] = array();
    $errorMsgs['Die Ressource ist ausserhalb der Site'][] = $errurl;
  }
  elseif($errno>=100 && $errno<1000){
    if(!isset($errorMsgs['HTTP-Statuscode: '.$errno])) $errorMsgs['HTTP-Statuscode: '.$errno] = array();
    $errorMsgs['HTTP-Statuscode: '.$errno][] = $errurl;
  }
  elseif($errno===2000){
    if(!isset($errorMsgs['Ressource aufgrund Mimetype nicht aufgenommen'])) $errorMsgs['Ressource aufgrund Mimetype nicht aufgenommen'] = array();
    $errorMsgs['Ressource aufgrund Mimetype nicht aufgenommen'][] = $errurl;
  }
  elseif($errno===3000){
    if(!isset($errorMsgs['Ressource durch Robots-Exclusion-Standard gesperrt'])) $errorMsgs['Ressource durch Robots-Exclusion-Standard gesperrt'] = array();
    $errorMsgs['Ressource durch Robots-Exclusion-Standard gesperrt'][] = $errurl;
  }
  elseif($errno>=1000 && $errno<2000){
    if(!isset($errorMsgs['cURL-Error #'.($errno-1000)])) $errorMsgs['cURL-Error #'.($errno-1000)] = array();
    $errorMsgs['cURL-Error #'.($errno-1000)][] = $errurl;
  }
  else{
    if(!isset($errorMsgs['Unbekannter Fehler'])) $errorMsgs['Unbekannter Fehler'] = array();
    $errorMsgs['Unbekannter Fehler'] = $errurl;
  }
}

$errorMsgs = array_unique($errorMsgs);
echo '<table>';
foreach($errorMsgs as $errorMsg => $errurls){
  echo '<tr><td colspan="3" style="color:#900">'.$errorMsg.'</td></tr>';
  echo '<tr><td colspan="3" style="font-size:11px;">';
  foreach($errurls as $errurl){
    echo htmlspecialchars($errurl).'<br />';
  }
  echo '</td></tr>';
}
if(count($errorMsgs)==0){
  echo '<tr><td colspan="3">Es gibt keine Meldungen.</td></tr>';
}
echo '</table>';

echo '<div>&nbsp;</div>';

echo round(microtime(true)-$timeStart, 2).' sec'; #%#%#%#%#%#%#%#%#%#%

echo PHP_EOL;

} ## POST [END]



#### FUNCTION ####

function sc_getNewSites($url, $referrer=''){
  global $ignoredParams;
  global $blockedFiles;
  global $sites4sitemap;
  global $errorsLog;
  foreach($blockedFiles as $blockedFile){
	if(preg_match($blockedFile, $url)){ // gesperrte Seite
	  $errorsLog[] = array($url, 3000); // $newSites = errno
	  return false;
	}
  }
  foreach($errorsLog as $err){
	if($err[0]===$url){ // bereits gemeldete Seite
	  return false;
	}
  }
  list($newSites, $nurl, $lastMod) = sc_scanURL($url, $referrer, 2);
  if(!is_array($newSites)){ // Fehlermeldung
    $errorsLog[] = array($nurl, $newSites); // $newSites = errno
	return false;
  }
  $sites4sitemap[$nurl] = $lastMod;
  foreach($newSites as $site){
    // Limit erreicht
	if(count($sites4sitemap) >= SC_MAX_SCAN_SITES)
	  return false;
    // gesperrte Seite
	// ungewollte Parameter entfernen
    $site = preg_replace($ignoredParams, '$1', $site);
    $site = preg_replace('#[\?&]$#', '', $site); // evtl. "?" oder "&" am Ende abschneiden
	// bereits gescannt
	if(isset($sites4sitemap[$site]))
	  continue;
	// Ausserhalb des Verzeichnisses
	if(strpos($site, SC_PROTOCOL.SC_HOSTNAME.SC_DIRECTORY)!==0)
	  continue;
	// neue Sites durchgehen
	sc_getNewSites($site, $nurl);
  }
  return true;
}


function sc_scanURL($urlToCall, $useReferer='', $followLocation=false, $breakScan=false){
  
  // Error bei Parse-URL verhindern
  $dotslashOutScheme = strpos($urlToCall, ':/', 6) && strpos($urlToCall, ':/')>5;
  if($dotslashOutScheme){ $uniqReplace = uniqid('_', true).'_'; $urlToCall = str_replace(':/', $uniqReplace, $urlToCall); }
  
  // URL parsen
  extract(parse_url($urlToCall));
  
  // Error bei Parse-URL verhindern [2]
  if($dotslashOutScheme){ $urlToCall = str_replace($uniqReplace, ':/', $urlToCall); }
  
  // gegebene URL überprüfen und evtl. noch korrigieren
  if(!isset($scheme) || $scheme !== 'http' || empty($host))
    return array(1, $urlToCall, 0);
  
  // anderer Host
  if($host !== SC_HOSTNAME)
    return array(2, $urlToCall, 0);
  
  // Slash am Ende des Hosts
  if(empty($path)){
    $urlToCall .= '/';
	$path = '/';
  }
  
  global $viewRobotsMeta;
  global $viewCanonical;
  global $blockedFiles;
  
  static $savedcookies = '';
  
  # Website auslesen
  $htreq = curl_init();
  curl_setopt($htreq, CURLOPT_URL, $urlToCall);
  curl_setopt($htreq, CURLOPT_CONNECTTIMEOUT, 5);
  curl_setopt($htreq, CURLOPT_USERAGENT, SC_AGENT);
  $header = array('Accept: '.$_SERVER['HTTP_ACCEPT'],
				  'Accept-Charset: '.$_SERVER['HTTP_ACCEPT_CHARSET'],
                  'Accept-Language: '.$_SERVER['HTTP_ACCEPT_LANGUAGE'],
				  'Range: bytes='.SC_BYTE_RANGE);
  curl_setopt($htreq, CURLOPT_HTTPHEADER, $header);
  curl_setopt($htreq, CURLOPT_ENCODING, 'gzip,deflate');
  curl_setopt($htreq, CURLOPT_REFERER, $useReferer);
  if($savedcookies!='')
    curl_setopt($htreq, CURLOPT_COOKIE, $savedcookies);
  curl_setopt($htreq, CURLOPT_HEADER, true);
  curl_setopt($htreq, CURLOPT_RETURNTRANSFER, true);
  $htres = curl_exec($htreq);
  
  // curl-Fehler
  if($htres===false){
	return array(1000+curl_errno($htreq), $urlToCall, 0);
  }
  
  $htresInfo = curl_getinfo($htreq);
  
  curl_close($htreq);
  
  // HTTP-Status prüfen
  $stat = $htresInfo['http_code'];
  if($stat!==200 && $stat!==206)
    return array($stat, $urlToCall, 0);
  
  $header = trim(substr($htres, 0, $htresInfo['header_size']));
  $headers = explode("\n", $header);
  $headers = array_map('trim', $headers);
  
  $contentType = isset($htresInfo['content_type']) ? $htresInfo['content_type'] : '';
  if(strpos($contentType, ';')!==false)
    $contentType = substr($contentType, 0, strpos($contentType, ';'));
  
  // Auf MimeType prüfen
  if($contentType!=='text/html' && $contentType!=='application/xhtml+xml' && $contentType!=='')
	return array(2000, $urlToCall, 0);
  
  // Cookies auslesen
  $precookies = $savedcookies; // alte Cookies
  $precookies = ($precookies!='') ? explode(';', $precookies) : array();
  $c = preg_match_all('#Set-Cookie: (.*);#U', $header, $tmpres); // neue Cookies
  $newcookies = ((bool)$c) ? $tmpres[1] : array();
  $cookies = array(); // alle Cookies
  foreach($precookies as $precookie){
    list($precookieName, $precookieVal) = explode('=', $precookie, 2);
	$cookies[$precookieName] = $precookieVal;
  }
  foreach($newcookies as $newcookie){
    list($newcookieName, $newcookieVal) = explode('=', $newcookie, 2);
	$cookies[$newcookieName] = $newcookieVal; // altes Cookie wird überschrieben, falls schon vorhanden
  }
  $actualcookies = array();
  foreach($cookies as $name => $value)
    $actualcookies[] = $name.'='.$value;
  $savedcookies = implode(';', $actualcookies); // Cookies speichern
  unset($actualcookies, $newcookies, $precookies, $cookies);
  
  // Header prüfen
  foreach($headers as $head){
    if((bool)$followLocation){
      if(strpos($head, 'Location: ')===0){
        $newurl = trim(substr($head, 10));
		if($newurl=='') continue;
		if($newurl[0]==='/') $newurl = $thisHost.$newurl;
	    return sc_scanURL($newurl, $urlToCall, $followLocation-1);
      }
    }
	if(strpos($head, 'Last-Modified: ')===0){
	  $lastMod = trim(substr($head, 15));
	  $lastMod = @strtotime($lastMod);
	}
  }
  if(empty($lastMod))
    $lastMod = time();
  
  // abbrechen, keine hrefs zurückgeben
  // ist nur fürs Cookie-Setzten
  if($breakScan){
    return array(array(), $urlToCall, $lastMod);
  }
  
  // der Host (ohne End-Slash)
  $thisHost = $scheme.'://'.$host;
  
  // Das Verzeichnis der aktuellen Datei
  $directory = substr($path, 0, strrpos($path, '/')+1);
  
  // Header abschneiden
  $htreq = substr($htreq, $htresInfo['header_size']);
  
  // Kommentare löschen
  $htres = preg_replace('#<!--(.*)-->#Uis', '', $htres);
  
  # Link-Basis auslesen
  $c = preg_match('#<base [^>]*href=("|\')(?<base>[^>]+)(\\1)[^>]+>#Uis', $htres, $tmpres);
  $urlbase = ($c) ? $tmpres['base'] : '';
  $basesp = parse_url($urlbase);
  if(!isset($basesp['scheme']) || !isset($basesp['host'])) // wenn ungültige Basis
    $urlbase = '';
  else{ // Basis mit End-Slash
    $urlbase = $basesp['scheme'].'://'.$basesp['host'].'/';
	if(isset($basesp['path']) && $basesp['path']!='')
	  $urlbase .= substr($basesp['path'], 1, strrpos($basesp['path'], '/')+1);
  }
  
  # Last-Modified-Metatag prüfen
  $c1 = preg_match('#<meta [^>]*http-equiv=("|\')last-modified(\\1) [^>]*content=("|\')(?<date>[^>]+)(\\3)[^>]+>#Uis', $htres, $tmpres1);
  $c2 = preg_match('#<meta [^>]*content=("|\')(?<date>[^>]+)(\\1) [^>]*http-equiv=("|\')last-modified(\\4)[^>]+>#Uis', $htres, $tmpres2);
  $robotsmetac = ($c1) ? $tmpres1['date'] : ( ($c2) ? $tmpres2['date'] : '' );
  if(($time = @strtotime($robotsmetac)) && $lastMod==time())
    $lastMod = $time;
  
  // Robots-Metatag prüfen
  if($viewRobotsMeta){
    $c1 = preg_match('#<meta [^>]*name=("|\')robots(\\1) [^>]*content=("|\')(?<meta>[^>]+)(\\3)[^>]+>#Uis', $htres, $tmpres1);
    $c2 = preg_match('#<meta [^>]*content=("|\')(?<meta>[^>]+)(\\1) [^>]*name=("|\')robots(\\4)[^>]+>#Uis', $htres, $tmpres2);
    $robotsmetac = ($c1) ? $tmpres1['meta'] : ( ($c2) ? $tmpres2['meta'] : '' );
	$noindex = preg_match('#noindex#i', $robotsmetac);
	$nofollow = preg_match('#nofollow#i', $robotsmetac);
	if($nofollow)
      return array(array(), $urlToCall, $lastMod);
	if($noindex)
      $blockedFiles[] = '#^'.preg_quote($urlToCall, '#').'$#';
  }
  
  // Canonical-Metatag prüfen
  $canonical = array();
  if($viewCanonical){
    $c1 = preg_match('#<link [^>]*rel=("|\')canonical(\\1) [^>]*href=("|\')(?<link>[^>]+)(\\3)[^>]+>#Uis', $htres, $tmpres1);
    $c2 = preg_match('#<link [^>]*href=("|\')(?<link>[^>]+)(\\1) [^>]*rel=("|\')canonical(\\4)[^>]+>#Uis', $htres, $tmpres2);
    $canonicalc = trim( ($c1) ? $tmpres1['link'] : ( ($c2) ? $tmpres2['link'] : '' ) );
	$canonical = array($canonicalc);
  }
  
  // Meta-Refresh
  preg_match_all('#<meta [^>]*content=("|\')[0-9;[:space:]]*url=([^>]+)(\\1)[^>]*>(.*)</a>#Uis', $htres, $metas);
  $metas = $metas[2];
  
  // href aus <a> auslesen
  $hrefs = array();
  preg_match_all('#<a [^>]*href=("|\')([^>]+)(\\1)[^>]*>(.*)</a>#Uis', $htres, $hrefs);
  $hrefs = $hrefs[2];
  
  // href aus <area> auslesen
  $areahrefs = array();
  preg_match_all('#<area [^>]*href=("|\')([^>]+)(\\1)[^>]*>#Uis', $htres, $areahrefs);
  $areahrefs = $areahrefs[2];
  
  # gefundene Links (hrefs)
  $hrefs = array_merge($hrefs, $areahrefs, $metas, $canonical);
  
  $hrefs = array_map('trim', $hrefs);
  $hrefs = array_map('html_entity_decode', $hrefs);
  
  # Quelltext löschen
  unset($htres);
  
  # alle hrefs durchgehen und zu absoluten URLs umschreiben
  foreach($hrefs as $key => &$href){
    // leerer Link
	if($href==''){
	  unset($hrefs[$key]);
	  continue; # LINK-DEL
	}
	// Link mit fehlendem Protokoll
	if(substr($href, 0, 2)==='//'){
	  $href = 'http:'.$href;
	}
	
    $linkbase = $urlbase;
	
	// Error bei Parse-URL verhindern
	$dotslashOutScheme = (strlen($href)>=6 && strpos($href, ':/', 6) && strpos($href, ':/')>5 );
	if($dotslashOutScheme){ $uniqReplace = uniqid('%_', true).'_'; $href = str_replace(':/', $uniqReplace, $href); }
	// href parsen
	$hrefsp = parse_url($href);
	// Error bei Parse-URL verhindern [2]
	if($dotslashOutScheme){ $href = str_replace($uniqReplace, ':/', $href); }
    
	// absolute URL auf ungewolltes Scheme überprüfen
    if(isset($hrefsp['scheme']) && $hrefsp['scheme']!=='http'){
	  unset($hrefs[$key]);
	  continue; # LINK-DEL
	}
    // absolute URL auf anderen Host überprüfen
    if(isset($hrefsp['scheme']) && $hrefsp['scheme']==='http' && isset($hrefsp['host']) && $hrefsp['host']!==$host){
	  unset($hrefs[$key]);
	  continue; # LINK-DEL
	}
	// lokaler Anker
    if(strpos($href, '#')===0){
	  unset($hrefs[$key]);
	  continue; # LINK-DEL
	}
	// Anker abschneiden
    if(strpos($href, '#')!==false){
	  $href = substr($href, 0, strpos($href, '#'));
	}
	// absolute URL zum Root ohne End-Slash
	if(isset($hrefsp['scheme']) && isset($hrefsp['host']) && (!isset($hrefsp['path']) || $hrefsp['path']=='')){
	  $href .= '/';
	}
	// selbe Seite
	if($href===$urlToCall){
	  unset($hrefs[$key]);
	  continue; # LINK-DEL
	}
    // selbe Seite, anderer Query-String
	if($href[0]==='?'){
	  $href = $thisHost.$path.$href;
	  continue; # LINK-SET
	}
    // interne absolute URL
	if($href[0]==='/'){
	  $href = $thisHost.$href;
	  continue; # LINK-SET
	}
	// absolute URL inkl. Host
	if(isset($hrefsp['scheme']) && isset($hrefsp['host'])){
	  continue; # LINK-SET
	}
	// dieses VZ als Link-Basis definieren, falls Link-Basis undefiniert
	if($linkbase==''){
	  $linkbase = $thisHost.$directory;
	}
	// selbe Ebene
	if(substr($href, 0, 2)==='./'){
	  $href = $linkbase.substr($href, 2);
	  continue; # LINK-SET
	}
	// höhere Ebenen
	$wentHigher = false;
	while(substr($href, 0, 3)==='../'){
	  $href = substr($href, 3);
	  if(substr_count($linkbase, '/')>3)
	    $linkbase = substr($linkbase, 0, strrpos(substr($linkbase, 0, -1), '/')+1);
	  $wentHigher = true;
	}
	if($wentHigher){
	  $href = $linkbase.$href;
	  continue; # LINK-SET
	}
	// selbe Ebene (letzte Möglichkeit)
	$href = $linkbase.$href;
	continue; # LINK-SET
  }
  
  $hrefs = array_unique($hrefs);
  
  // Verweise auf sich selbst löschen
  if(array_search($urlToCall, $hrefs)!==false)
    unset($hrefs[array_search($urlToCall, $hrefs)]);
  
  return array($hrefs, $urlToCall, $lastMod);
}

?>



<form action="<?php echo preg_replace('#\?.*$#', '', $_SERVER['REQUEST_URI']) ?>" method="get">

<table>

<tr>
 <td colspan="3" style="color:#00c;">Lade Deine Einstellungen aus einem gespeicherten Profil.</td>
</tr>

<tr>
 <td>Profil auswählen</td>
 <td><select name="sc_selectprofile" style="width:200px">
<?php
$profs = glob('sc.profile.*.txt');
if(!is_array($profs)) $profs = array();
foreach($profs as $prof){
  $profName = preg_replace('#^sc\.profile\.(.*)\.txt$#', '$1', $prof);
  $profName = htmlspecialchars($profName);
  echo '<option value="'.$profName.'">'.$profName.'</option>';
}
if(count($profs)==0){
  echo '<option value="">Es gibt noch keine Profile</option>';
}
?> 
</select></td>
 <td>Wähle das zu ladende Profil.</td>
</tr>

<tr>
 <td>Laden</td>
 <td><input value="Profil laden" type="submit" /></td>
 <td> </td>
</tr>

</table>

</form>

<div>&nbsp;</div>

<form action="<?php echo preg_replace('#\?.*$#', '', $_SERVER['REQUEST_URI']) ?>" method="post">

<table>

<tr>
 <td colspan="3" style="color:#00c;">Fülle die nachfolgenden Felder so aus, wie sie Deinen Anforderungen entsprechen. Die standardmässig gesetzten Werte sind so gewählt, dass man Angaben überspringen kann, wenn man die Funktion dahinter nicht kennt.</td>
</tr>

<tr>
 <td>Name der Sitemap-Datei</td>
 <td><input name="sc_sitemapFile" value="<?php echo !empty($preconfigs['sitemapFile'])?$preconfigs['sitemapFile']:'sitemap.xml'; ?>" type="text" style="width:200px" maxlength="32" /></td>
 <td>Unter diesem Namen ist die Sitemap später erreichbar. Der Name sollte nur aus den Buchstaben a-z sowie den Satzzeichen Punkt (.), Bindestrich (-) und Unterstrich (_) bestehen. Als Dateiendung sollte (muss) ".xml" gewählt werden. Standardmässig heisst die Datei "sitemap.xml"</td>
</tr>

<tr>
 <td>Name der XSLT-Datei</td>
 <td><input name="sc_sitemapXsltFile" value="<?php echo !empty($preconfigs['sitemapXsltFile'])?$preconfigs['sitemapXsltFile']:'sc.sitemap.xsl'; ?>" type="text" style="width:200px" maxlength="32" /></td>
 <td>Unter diesem Namen ist die XSLT-Datei zur Sitemap später erreichbar. Der Name sollte nur aus den Buchstaben a-z sowie den Satzzeichen Punkt (.), Bindestrich (-) und Unterstrich (_) bestehen. Als Dateiendung sollte (muss) ".xsl" gewählt werden.</td>
</tr>

<tr>
 <td>URL der Sitemap in die robots.txt eintragen</td>
 <td><input name="sc_entryRobotsTxt" value="y" type="checkbox" <?php echo (isset($preconfigs['entryRobotsTxt'])&&!$preconfigs['entryRobotsTxt'])?'':'checked="checked" '; ?>/></td>
 <td>Auswählen, wenn die URL der Sitemap in die robots.txt eintragen werden soll (empfohlen).</td>
</tr>

<tr>
 <td>Seiten-Limit</td>
 <td><input name="sc_scanLimit" value="<?php echo !empty($preconfigs['scanLimit'])?strval($preconfigs['scanLimit']):'1000'; ?>" type="text" style="width:50px" maxlength="5" /></td>
 <td>Maximale Anzahl Seiten, welche gescannt werden sollten.</td>
</tr>

<tr>
 <td>Verzeichnis</td>
 <td><input name="sc_scanDirectory" value="<?php echo !empty($preconfigs['scanDirectory'])?$preconfigs['scanDirectory']:str_replace('//', '/', dirname($_SERVER['REQUEST_URI']).'/'); ?>" type="text" style="width:200px" maxlength="64" /></td>
 <td>Falls nur ein bestimmtes Verzeichnis (inkl. Unterverzeichnisse) gescannt werden sollten, kann dieses hier eigetragen werden. (Mit Slash am Anfang und Ende.)</td>
</tr>

<tr>
 <td>robots.txt beachten</td>
 <td><input name="sc_viewRobotsTxt" value="y" type="checkbox" <?php echo (isset($preconfigs['viewRobotsTxt'])&&!$preconfigs['viewRobotsTxt'])?'':'checked="checked" '; ?>/></td>
 <td>Auswählen, wenn URLs, welche durch die robots.txt gesperrt sind, nicht gescannt werden sollen (empfohlen).</td>
</tr>

<tr>
 <td>robots-Metatag beachten</td>
 <td><input name="sc_viewRobotsMeta" value="y" type="checkbox" <?php echo (isset($preconfigs['viewRobotsMeta'])&&!$preconfigs['viewRobotsMeta'])?'':'checked="checked" '; ?>/></td>
 <td>Auswählen, wenn der Metatag "robots" beachtet werden soll (empfohlen).</td>
</tr>

<tr>
 <td>Canonical-Linktag beachten</td>
 <td><input name="sc_viewCanonical" value="y" type="checkbox" <?php echo (isset($preconfigs['viewCanonical'])&&!$preconfigs['viewCanonical'])?'':'checked="checked" '; ?>/></td>
 <td>Auswählen, wenn Seiten unter dem Linktag "canonical" gescannt werden sollen (empfohlen).</td>
</tr>

<tr>
 <td>Gesperrte Seiten</td>
 <td><textarea name="sc_blockedLinks" cols="25" rows="5"><?php echo (!empty($preconfigs['blockedLinks'])||@$preconfigs['blockedLinks']==='')?htmlspecialchars($preconfigs['blockedLinks']):'/admin/*
/cgi-bin/*'; ?></textarea></td>
 <td>Seiten, welche nicht gescannt werden sollen. Pro Zeile eine Angabe. Ein Stern (*) steht als Wildcard für keine oder mehrere beliebige Zeichen zur Verfügung.</td>
</tr>

<tr>
 <td>Ignorierte Parameter</td>
 <td><textarea name="sc_ignoredParams" cols="25" rows="5"><?php echo (!empty($preconfigs['ignoredParams'])||@$preconfigs['ignoredParams']==='')?htmlspecialchars($preconfigs['ignoredParams']):'PHPSESSID
order
sort'; ?></textarea></td>
 <td>Parameter, welche in einer URL nicht beachtet werden sollen. Pro Zeile ein Parameter.</td>
</tr>

<tr>
 <td>Prioritäten (priority)</td>
 <td><textarea name="sc_sitePriority" cols="25" rows="5"><?php echo (!empty($preconfigs['sitePriority'])||@$preconfigs['sitePriority']==='')?htmlspecialchars($preconfigs['sitePriority']):'1.0 /
0.8 /*
0.3 /archive/*'; ?></textarea></td>
 <td>Spezifische Angaben zur "priority" für bestimmte Seiten. Pro Zeile eine Angabe. Die Priorität wird als Zahl zwischen 0.0 und 1.0 (eine Nachkommastelle) angegeben, gefolgt von der jeweiligen URL (mit Leerzeichen getrennt). Der Standard Wert ist 0.5. Ein Stern (*) steht als Wildcard für eines oder mehrere beliebige Zeichen <b>ausser Slash ("/")</b> zur Verfügung.</td>
</tr>

<tr>
 <td>Frequenz (changefreq)</td>
 <td><textarea name="sc_siteFrequency" cols="25" rows="5"><?php echo (!empty($preconfigs['siteFrequency'])||@$preconfigs['siteFrequency']==='')?htmlspecialchars($preconfigs['siteFrequency']):'daily /
never /archive/*'; ?></textarea></td>
 <td>Spezifische Angaben zur "changefreq" für bestimmte Seiten. Pro Zeile eine Angabe. Die Frequenz wird als englisches Wort angegeben (mögliche Werte: always, hourly, daily, weekly, monthly, yearly, never), gefolgt von der jeweiligen URL (mit Leerzeichen getrennt). Der Standard Wert ist "weekly". Ein Stern (*) steht als Wildcard für eines oder mehrere beliebige Zeichen <b>ausser Slash ("/")</b> zur Verfügung.</td>
</tr>

<tr>
 <td colspan="3" style="color:#00c;">Du kannst Deine Einstellungen in ein Profil speichern. Beim wiederholten generieren der Sitemap kann das Profil geladen werden und die Sitemap mit denselben Einstellungen erstellt werden.</td>
</tr>

<tr>
 <td>Als Profil speichern</td>
 <td><input name="sc_saveProfile" value="y" type="checkbox" /></td>
 <td>Auswählen, wenn die gewählten Einstellungen in eine Profil-Datei gespeichert werden sollen. Dies vereinfacht es, Durchläufe zu wiederholen, und ermöglicht es, Cronjobs auf das Script anzusetzen.</td>
</tr>

<tr>
 <td>Profil-Name</td>
 <td><input name="sc_saveProfileName" value="Profil_1" type="text" style="width:200px" maxlength="32" /></td>
 <td>Der Name des Profils. Der Name sollte nur aus den Buchstaben a-z sowie den Satzzeichen Punkt (.), Bindestrich (-) und Unterstrich (_) bestehen. Diese Information muss nur angegeben werden, wenn die Einstellungen in ein Profil gespeichert werden.</td>
</tr>

</table>

<div>&nbsp;</div>

<table>

<tr>
 <td>Fertig</td>
 <td><input name="sc_send" value="Sitemap generieren" type="submit" /></td>
 <td> </td>
</tr>

</table>

</form>

</div>

<div id="footer">
<a href="http://floern.com/software/sitemapcompiler" onclick="window.open(this.href);return false;">SitemapCompiler 1.0</a> – 
<a href="http://www.sitemaps.org/" onclick="window.open(this.href);return false;">About Sitemaps</a>
</div>
	
</body>
</html>