/*###############################################
#  SizingNavigation                Version 1.0  #
#  by Floern                        30.09.2009  #
#  http://floern.com/software/sizingnavigation  #
###############################################*/

// Grösse der Icons (in Pixel)
var minWidth = 32;
var minHeight = 32;
// Grösse der gezoomten Icons (in Pixel)
var maxWidth = 42;
var maxHeight = 42;

// Geschwindigkeit der Grössenänderung
var resizeSpeed = 15; // je kleiner desto schneller

/* Ab hier gibt's nichts anzupassen */
var resizeDirection = new Array();
var uppersizeTmO = new Array();
var lowersizeTmO = new Array();

// Spacer bearbeiten, damit die Navi eine fixe Höhe hat
spacerImg = document.getElementById('sizingNavigationSpacer');
spacerImg.style.width = '1px';
spacerImg.style.height = maxHeight + 'px';
spacerImg.style.padding = '0';
spacerImg.style.border = '0';

// Elemente der Navigation überprüfen und bearbeiten
naviBarObjs = document.getElementById('sizingNavigation').childNodes;
for(i=0; i<naviBarObjs.length; i++){
 if(naviBarObjs[i].nodeName == 'A'){ // Alle Links der Navigation bearbeiten
  naviBarIcon = naviBarObjs[i].childNodes[0]; // verlinkte Grafik
  // Breite und Höhe setzen
  naviBarIcon.style.width = minWidth + 'px';
  naviBarIcon.style.height = minHeight + 'px';
  // Events setzen
  naviBarIcon.onmouseover = function(e){ sizingNavigationExpand(this); }
  naviBarIcon.onmouseout = function(e){ sizingNavigationReduce(this); }
 }
 else if(naviBarObjs[i].nodeType == 3)
  // Text-Nodes zwischen den Bildern löschen, da sonst ein ungewollter Abstand entsteht
  naviBarObjs[i].data = '';
}

// Funktion zum Vergrössern der Grafik
function sizingNavigationExpand(iconId, notset){
 // Verkleinerung stoppen
 lowersizeTmO[iconId.src] = null;
 
 // Vergrösserung wurde soeben gestartet
 if(notset!=true)
  resizeDirection[iconId.src] = 1;
 
 // Verkleinerung wurde soeben gestartet => Verkleinerung stoppen
 if(resizeDirection[iconId.src] != 1)
  return;
 
 // Neue Grössen berechnen
 newWidth = parseInt(iconId.style.width) + resizeDirection[iconId.src];
 newHeight = parseInt(iconId.style.height) + resizeDirection[iconId.src];
 
 // Abbrechen, wenn Zielgrösse erreicht
 if(newWidth > maxWidth || newHeight > maxHeight)
  return;
 
 // Neue Grössen setzen
 iconId.style.width = newWidth + 'px';
 iconId.style.height = newHeight + 'px';
 
 // spezifisches Timeout starten
 uppersizeTmO[iconId.src] = window.setTimeout(function(){ sizingNavigationExpand(iconId, true) }, resizeSpeed);
}

// Funktion zum Verkleinern der Grafik
function sizingNavigationReduce(iconId, notset){
 // Vergrösserung stoppen
 uppersizeTmO[iconId.src] = null;
 
 // Verkleinerung wurde soeben gestartet
 if(notset!=true)
  resizeDirection[iconId.src] = -1;
 
 // Vergrösserung wurde soeben gestartet => Verkleinerung stoppen
 if(resizeDirection[iconId.src] != -1)
  return;
 
 // Neue Grössen berechnen
 newWidth = parseInt(iconId.style.width) + resizeDirection[iconId.src];
 newHeight = parseInt(iconId.style.height) + resizeDirection[iconId.src];
 
 // Abbrechen, wenn Zielgrösse erreicht
 if(newWidth < minWidth || newHeight < minHeight)
  return;
 
 // Neue Grössen setzen
 iconId.style.width = newWidth + 'px';
 iconId.style.height = newHeight + 'px';
 
 // spezifisches Timeout starten
 lowersizeTmO[iconId.src] = window.setTimeout(function(){ sizingNavigationReduce(iconId, true) }, resizeSpeed);
}

// Script ENDE